<?php
// بارگذاری فایل
require_once __DIR__ . '/../../modules/addons/amoot_sms/functions.php';
// loggerAmoot('include/hooks/amoot_sms_hooks.php', 'Hooks file loaded');
use WHMCS\Database\Capsule;

// دریافت شماره موبایل کاربر
function getClientPhone($userId)
{
    $client = Capsule::table('tblclients')->where('id', $userId)->first();
    return $client ? $client->phonenumber : null;
}

// دریافت اطلاعات کامل کاربر
function getClientDetails($userId)
{
    return Capsule::table('tblclients')->where('id', $userId)->first();
}

// دریافت تنظیمات ماژول
function getAddonSettings()
{
    $moduleName = 'amoot_sms'; // ← با نام در amoot_sms.php هماهنگ باشد
    $settings = Capsule::table('tbladdonmodules')
        ->where('module', $moduleName)
        ->pluck('value', 'setting');

    return $settings;
}

function getClientPhoneNumber($clientId)
{
    try {
        $client = Capsule::table('tblclients')->where('id', $clientId)->first();
        if ($client && isset($client->phonenumber)) {
            return $client->phonenumber;
        }
    } catch (\Exception $e) {
        // خطاها رو اینجا می‌تونی هندل کنی یا لاگ کنی
    }
    return null;
}

// function filterPhoneNumber($phone)
// {
//     return preg_replace('/[^\d+]/', '', $phone);
// }

function notifyAdmins($message, $adminPhonesRaw, $token)
{
    $phones = array_map('trim', explode(',', $adminPhonesRaw));

    foreach ($phones as $phone) {
        $cleanedPhone = filterPhoneNumber($phone);
        if ($cleanedPhone) {
            // sendSMS($cleanedPhone, $message);
            // loggerAmoot('AdminNotify', "پیام ارسال شد به {$cleanedPhone}: $message");
            amoot_sms_send($cleanedPhone, $message, $token);
        }
    }
}



// 📌 رویداد ورود کاربر
add_hook('UserLogin', 1, function ($vars) {
    $settings = getAddonSettings();
    $userId = $vars['user']['id'] ?? null;
    if (!$userId) {
        return;
    }

    $client = getClientDetails($userId);
    $phone = $client->phonenumber ?? null;
    $phone_2 = getClientPhoneNumber($userId);

    // loggerAmoot('ClientLogin', json_encode($vars));
    // loggerAmoot('ClientLogin', "User ID: $userId, Phone: $phone, Phone 2: $phone_2");

    if ($phone_2 && !empty($settings['login_message'])) {
        $messageTemplate = $settings['login_message'];
        $replace = [
            'firstname' => $client->firstname,
            'lastname' => $client->lastname,
            'email' => $client->email,
            'ip' => $_SERVER['REMOTE_ADDR'] ?? 'unknown',
            'date' => date('Y-m-d H:i:s'),
        ];
        $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
        // loggerAmoot('ClientLogin', $finalMessage);
        amoot_sms_send(filterPhoneNumber($phone), $finalMessage, $settings['token']);
    }
});


// رویداد ایجاد فاکتور
add_hook('InvoiceCreated', 1, function ($vars) {
    $settings = getAddonSettings();
    $invoice = Capsule::table('tblinvoices')->where('id', $vars['invoiceid'])->first();
    if (!$invoice)
        return;

    $client = getClientDetails($invoice->userid);
    $phone = $client->phonenumber ?? null;
    if (!$phone)
        return;

    $items = Capsule::table('tblinvoiceitems')->where('invoiceid', $invoice->id)->get();

    $isRenewal = false;
    $products = [];
    $domains = [];
    $nextDueDates = [];

    foreach ($items as $item) {
        // بررسی تمدید
        if (stripos($item->description, 'renewal') !== false || $item->type === 'Hosting' || $item->type === 'Domain') {
            $isRenewal = true;
        }

        if ($item->type === 'Hosting') {
            $hosting = Capsule::table('tblhosting')->where('id', $item->relid)->first();
            if ($hosting) {
                $product = Capsule::table('tblproducts')->where('id', $hosting->packageid)->first();
                if ($product) {
                    $products[] = $product->name;
                }
                if (!empty($hosting->domain)) {
                    $domains[] = $hosting->domain;
                }
                if (!empty($hosting->nextduedate) && $hosting->nextduedate != '0000-00-00') {
                    $nextDueDates[] = $hosting->nextduedate;
                }
            }
        } elseif ($item->type === 'Domain') {
            $domain = Capsule::table('tbldomains')->where('id', $item->relid)->first();
            if ($domain) {
                $domains[] = $domain->domain;
            }
        }
    }

    // تبدیل آرایه‌ها به رشته با کاما
    $productsString = implode(', ', array_unique($products));
    $domainsString = implode(', ', array_unique($domains));

    sort($nextDueDates);
    $nextDueDate = count($nextDueDates) ? $nextDueDates[0] : '';

    if ($isRenewal && !empty($settings['order_renewed'])) {
        $messageTemplate = $settings['order_renewed'];
    } elseif (!empty($settings['order_created'])) {
        $messageTemplate = $settings['order_created'];
    } else {
        return;
    }

    $replace = [
        'firstname' => $client->firstname,
        'lastname' => $client->lastname,
        'email' => $client->email,
        'invoiceid' => $invoice->id,
        'amount' => $invoice->total,
        'date' => date('Y-m-d H:i'),
        'product' => $productsString,
        'domain' => $domainsString,
        'nextduedate' => $nextDueDate,
    ];

    $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);

    amoot_sms_send(filterPhoneNumber($phone), $finalMessage, $settings['token']);
});




// 📌 رویداد پرداخت فاکتور
add_hook('InvoicePaid', 1, function ($vars) {
    $settings = getAddonSettings();
    $invoice = Capsule::table('tblinvoices')->where('id', $vars['invoiceid'])->first();
    if ($invoice) {
        $client = getClientDetails($invoice->userid);
        $phone = $client->phonenumber ?? null;
        if ($phone && !empty($settings['order_paid'])) {
            $messageTemplate = $settings['order_paid'];
            $replace = [
                'firstname' => $client->firstname,
                'lastname' => $client->lastname,
                'email' => $client->email,
                'invoiceid' => $invoice->id,
                'amount' => $invoice->total,
                'date' => date('Y-m-d H:i'),
            ];
            $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
            amoot_sms_send(filterPhoneNumber($phone), $finalMessage, $settings['token']);
        }
    }
});

// 📌 رویداد لغو فاکتور
add_hook('InvoiceCancelled', 1, function ($vars) {
    $settings = getAddonSettings();
    $invoice = Capsule::table('tblinvoices')->where('id', $vars['invoiceid'])->first();
    if ($invoice) {
        $client = getClientDetails($invoice->userid);
        $phone = $client->phonenumber ?? null;
        if ($phone && !empty($settings['order_paid'])) {
            $messageTemplate = $settings['order_paid'];
            $replace = [
                'firstname' => $client->firstname,
                'lastname' => $client->lastname,
                'email' => $client->email,
                'invoiceid' => $invoice->id,
                'amount' => $invoice->total,
                'date' => date('Y-m-d H:i'),
            ];
            $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
            amoot_sms_send(filterPhoneNumber($phone), $finalMessage, $settings['token']);
        }
    }
});

add_hook('TicketOpen', 1, function ($vars) {
    $settings = getAddonSettings();
    // loggerAmoot('TicketOpen', json_encode($vars));
    $ticket = Capsule::table('tbltickets')->where('id', $vars['ticketid'])->first();

    if ($ticket) {
        $client = getClientDetails($ticket->userid);
        $phone = $client->phonenumber ?? null;
        if ($phone && !empty($settings['order_paid'])) {
            $messageTemplate = $settings['order_paid'];
            $replace = [
                'firstname' => $client->firstname,
                'lastname' => $client->lastname,
                'email' => $client->email,
                'title' => $ticket->title,
                'ticket_id' => $ticket->tid,
                'urgency' => $ticket->urgency,
                'status' => $ticket->status,
                'date' => date('Y-m-d H:i:s'),
            ];
            $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
            amoot_sms_send(filterPhoneNumber($phone), $finalMessage, $settings['token']);
        }
    }

    $msg = "📩 تیکت جدید از کاربر {$vars['userid']} با عنوان: {$vars['subject']}";
    // loggerAmoot('TicketOpen', $msg);
    amoot_sms_send($msg, $settings['admin_phones']);
});


add_hook('TicketUserReply', 1, function ($vars) {
    $settings = getAddonSettings();

    $ticket = Capsule::table('tbltickets')->where('id', $vars['ticketid'])->first();


    // loggerAmoot('ticket_reply', json_encode($vars));

    if ($ticket) {
        $client = getClientDetails($ticket->userid);

        $phone = $client->phonenumber ?? null;

        // loggerAmoot('ticket_reply', 'phone: ' . $phone);

        if ($phone && !empty($settings['ticket_reply'])) {
            $messageTemplate = $settings['ticket_reply'];
            $replace = [
                'firstname' => $client->firstname,
                'lastname' => $client->lastname,
                'email' => $client->email,
                'title' => $ticket->title,
                'ticket_id' => $ticket->tid,
                'urgency' => $ticket->urgency,
                'status' => $ticket->status,
                'date' => date('Y-m-d H:i:s'),
            ];
            $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
            amoot_sms_send(filterPhoneNumber($phone), $finalMessage, $settings['token']);
        }


    }

});


add_hook('TicketAdminReply', 1, function ($vars) {
    $settings = getAddonSettings();
    // loggerAmoot('ticket_reply_admin', json_encode($vars));
    $ticket = Capsule::table('tbltickets')->where('id', $vars['ticketid'])->first();

    $adminMobile = $settings['admin_phones'];

    if ($ticket) {
        if (!empty($adminMobile)) {
            $mobiles = array_map('trim', explode(',', $adminMobile));

            foreach ($mobiles as $mobile) {
                if (!empty($mobile)) {
                    $client = getClientDetails($ticket->userid);
                    // $phone = $client->phonenumber ?? null;
                    if ($mobile && !empty($settings['ticket_reply_admin'])) {
                        $messageTemplate = $settings['ticket_reply_admin'];
                        $replace = [
                            'firstname' => $client->firstname,
                            'lastname' => $client->lastname,
                            'email' => $client->email,
                            'title' => $ticket->title,
                            'ticket_id' => $ticket->tid,
                            'urgency' => $ticket->urgency,
                            'status' => $ticket->status,
                            'date' => date('Y-m-d H:i:s'),
                        ];
                        $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
                        amoot_sms_send(filterPhoneNumber($mobile), $finalMessage, $settings['token']);
                    }
                }
            }
        }


    }

});

add_hook('TicketStatusChange', 1, function ($vars) {
    $settings = getAddonSettings();
    // loggerAmoot('ticket_status_changed', json_encode($vars));
    $ticket = Capsule::table('tbltickets')->where('id', $vars['ticketid'])->first();

    $adminMobile = $settings['admin_phones'];

    if ($ticket) {
        if (!empty($adminMobile)) {
            // $mobiles = array_map('trim', explode(',', $adminMobile));

            // foreach ($mobiles as $mobile) {
            //     if (!empty($mobile)) {
            $client = getClientDetails($ticket->userid);
            $phone = $client->phonenumber ?? null;
            if ($phone && !empty($settings['ticket_status_changed'])) {
                $messageTemplate = $settings['ticket_status_changed'];
                $replace = [
                    'firstname' => $client->firstname,
                    'lastname' => $client->lastname,
                    'email' => $client->email,
                    'title' => $ticket->title,
                    'ticket_id' => $ticket->tid,
                    'urgency' => $ticket->urgency,
                    'status' => $ticket->status,
                    'date' => date('Y-m-d H:i:s'),
                ];
                $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
                amoot_sms_send(filterPhoneNumber($phone), $finalMessage, $settings['token']);
            }
            //     }
            // }
        }


    }

});

add_hook('AdminLogin', 1, function ($vars) {
    // loggerAmoot('AdminLogin', 'Hook Triggered');

    $settings = getAddonSettings();
    // loggerAmoot('AdminLogin', 'Settings: ' . json_encode($settings));

    $adminId = $vars['adminid'] ?? null;
    if (!$adminId) {
        // loggerAmoot('AdminLogin', 'Admin ID not found in $vars');
        return;
    }

    $admin = Capsule::table('tbladmins')->where('id', $adminId)->first();
    if (!$admin) {
        // loggerAmoot('AdminLogin', 'Admin not found in DB for ID: ' . $adminId);
        return;
    }

    $adminMobile = $settings['admin_phones'] ?? '';
    // loggerAmoot('AdminLogin', 'Raw adminPhones: ' . $adminMobile);

    $mobiles = array_map('trim', explode(',', $adminMobile));

    foreach ($mobiles as $mobile) {
        if (!empty($mobile)) {
            // loggerAmoot('AdminLogin', 'Sending SMS to: ' . $mobile);

            if (!empty($settings['admin_login_message'])) {
                $messageTemplate = $settings['admin_login_message'];
                $replace = [
                    'firstname' => $admin->firstname ?? '',
                    'lastname' => $admin->lastname ?? '',
                    'email' => $admin->email ?? '',
                    'ip' => $_SERVER['REMOTE_ADDR'] ?? 'unknown',
                    'date' => date('Y-m-d H:i:s'),
                ];

                $finalMessage = amoot_sms_parse_template($messageTemplate, $replace);
                // loggerAmoot('AdminLogin', "Final message: $finalMessage");

                amoot_sms_send(filterPhoneNumber($mobile), $finalMessage, $settings['token']);
            } else {
                // loggerAmoot('AdminLogin', 'admin_login_message is empty in settings');
            }
        }
    }
});

