<?php


if (!defined("WHMCS"))
    die("This file cannot be accessed directly");

use WHMCS\View\Asset;
use WHMCS\Database\Capsule;

require_once __DIR__ . '/functions.php';
// require_once __DIR__ . '/hooks.php';

function getAddonSettings_sms()
{
    $moduleName = 'amoot_sms'; // ← با نام در amoot_sms.php هماهنگ باشد
    $settings = Capsule::table('tbladdonmodules')
        ->where('module', $moduleName)
        ->pluck('value', 'setting');

    return $settings;
}

if ($_GET['module'] === 'amoot_sms' && $_GET['action'] === 'checkPattern' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');

    $pattern = trim($_POST['pattern'] ?? '');

    // ارسال به وب‌سرویس شما
    $response = checkPatternViaApi($pattern);
    $response = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['success' => false, 'message' => 'خطا در تجزیه پاسخ از سرور.']);
        exit;
    }

    // اگر پاسخ از سرور به صورت آرایه باشد
    if (is_array($response) && isset($response['Status'])) {
        if ($response['Status'] === 'Success') {

            $result = null;

            if (isset($response['Data']) && is_array($response['Data'])) {
                foreach ($response['Data'] as $item) {
                    if (isset($item['ID']) && $item['ID'] == $pattern) {
                        $result = $item;
                        break;
                    }
                }
            }

            echo json_encode(['success' => true, 'data' => $result]);
        } else {
            echo json_encode(['success' => false, 'data' => $response['msg'] ?? 'نامشخص']);
        }

        // echo json_encode(['success' => false, 'message' => 'پاسخ نامعتبر از سرور.']);
        exit;
    }


    echo json_encode($response);
    exit;

    if ($response['status'] === true) {
        echo json_encode(['success' => true, 'message' => $response['msg']]);
    } else {
        echo json_encode(['success' => false, 'message' => $response['msg'] ?? 'نامشخص']);
    }
    exit;
}

function checkPatternViaApi($pattern)
{

    $settings = getAddonSettings_sms();
    if (empty($settings['token'])) {
        return ['status' => false, 'msg' => 'توکن API تنظیم نشده است.'];
    }

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://portal.amootsms.com/rest/PatternCodeList?Token=' . $settings['token'],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET'
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    // echo $response;
    return $response;
    // شبیه‌سازی تماس به API شما
    // می‌تونی به جای این قسمت curl یا هر چیزی بزنی
    // if (strpos($pattern, '{firstname}') !== false) {
    //     return ['status' => true, 'msg' => 'الگو دارای نام کاربر است.'];
    // }
    // return ['status' => false, 'msg' => 'الگوی ورودی قابل شناسایی نیست.'];
}


add_hook('AdminAreaFooterOutput', 1, function ($vars) {
    ob_start(); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const configBox = document.querySelector('#amoot_smsconfig');
            if (!configBox) return;

            const textarea = configBox.querySelectorAll("textarea");
            // if (!textarea) return;

            textarea.forEach(function (el) {
                const wrapper = document.createElement('div');
                wrapper.style.marginTop = '10px';
                wrapper.innerHTML = `
            <input type="text" class="amootPatternInput" placeholder="کد الگو را وارد کنید" />
            <button type="button" class="amootPatternCheckBtn">بررسی الگو</button>
            <div class="amootPatternResult" style="margin:5px 0;"></div>
            <div class="amootPatternDynamicFields" style="margin:10px 0;"></div>
        `;

                el.parentNode.appendChild(wrapper);
            });



            document.querySelectorAll('.amootPatternCheckBtn').forEach(element => {
                element.addEventListener('click', function (e) {
                    const input = element.parentNode.querySelector('.amootPatternInput');
                    const resultBox = element.parentNode.querySelector('.amootPatternResult');
                    const dynamicFields = element.parentNode.querySelector('.amootPatternDynamicFields');

                    fetch('configaddonmods.php?action=checkPattern&module=amoot_sms', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: 'pattern=' + encodeURIComponent(input.value)
                    })
                        .then(res => res.json())
                        .then(data => {
                            if (data.success && data.data && data.data.Patterns) {
                                resultBox.innerText = '✅ الگو معتبر است.';
                                resultBox.style.color = 'green';
                                dynamicFields.innerHTML = '';

                                data.data.Patterns.forEach(key => {
                                    dynamicFields.innerHTML += `
                            <div>
                                <label>${key}:</label>
                                <input type="text" data-key="${key}" placeholder="{${key}}" style="margin-right:5px" />
                            </div>`;
                                });

                                dynamicFields.innerHTML += `<button type="button" class="amootInsertPatternBtn">درج در textarea</button>`;

                                console.log('Insert BTN : ', element.parentNode.querySelector('.amootInsertPatternBtn'));

                                element.parentNode.querySelector('.amootInsertPatternBtn').addEventListener('click', function () {
                                    let result = 'pcode:' + data.data.ID + '\r';

                                    dynamicFields.querySelectorAll('input').forEach(input => {
                                        const key = input.dataset.key;
                                        const val = input.value.trim() || '{' + key + '}';
                                        result += key + ':' + val + '\r';
                                    });
                                    element.parentNode.parentNode.querySelector('textarea').value = '\r' + result;
                                });

                            } else {
                                resultBox.innerText = '❌ ' + (data.message || 'الگو یافت نشد');
                                resultBox.style.color = 'red';
                                dynamicFields.innerHTML = '';
                            }
                        })
                        .catch(() => {
                            resultBox.innerText = '❌ خطای ارتباط با سرور';
                            resultBox.style.color = 'red';
                            dynamicFields.innerHTML = '';
                        });
                });
            });
        });
    </script>
    <?php
    return ob_get_clean();
});

function amoot_sms_config()
{



    return [
        'name' => 'Amoot SMS Notifier',
        'description' => 'ارسال پیامک هنگام ورود، پرداخت و مدیریت سرویس‌ها',
        'version' => '1.0',
        'author' => 'YourName',
        'fields' => [



            'token' => [
                'FriendlyName' => 'توکن API',
                'Type' => 'text',
                'Size' => '50',
                'Description' => 'توکن ارسال پیامک که از سامانه پیامک دریافت می‌کنید.',
            ],
            'adminPhones' => [
                'FriendlyName' => 'شماره مدیران',
                'Type' => 'text',
                'Size' => '200',
                'Description' => 'شماره‌ها را با کاما جدا کنید. مثلاً: 09120000000,09350000000',
            ],

            'login_message' => [
                'FriendlyName' => 'پیام ورود',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'پیامی که هنگام ورود کاربر ارسال می‌شود.<br>
            <b>متغیرهای قابل استفاده:</b><br>
            <code>{firstname}, {lastname}, {email}, {ip}, {date}</code>',
            ],

            'admin_login_message' => [
                'FriendlyName' => 'پیام ورود مدیر',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'پیامی که هنگام ورود مدیر ارسال می‌شود.<br>
            <b>متغیرهای قابل استفاده:</b><br>
            <code>{firstname}, {lastname}, {email}, {ip}, {date}</code>',
            ],

            'order_created' => [
                'FriendlyName' => 'ایجاد سرویس',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'هنگام ایجاد سرویس جدید.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {email}, {product},{invoiceid},{amount}, {domain}, {date}</code>',
            ],

            'order_paid' => [
                'FriendlyName' => 'پرداخت موفق',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'پس از پرداخت موفق یک فاکتور.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {email}, {product},{invoiceid},{amount}, {domain}, {date}</code>',
            ],

            'order_terminated' => [
                'FriendlyName' => 'سرویس لغو شده',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'هنگامی که یک سرویس لغو (Terminate) می‌شود.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {product}, {domain}, {date}</code>',
            ],

            'order_renewed' => [
                'FriendlyName' => 'تمدید سرویس',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'پس از تمدید سرویس.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {email}, {product},{invoiceid},{amount}, {domain}, {date}, {nextduedate}</code>',
            ],

            'order_expired' => [
                'FriendlyName' => 'انقضای سرویس',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'وقتی سرویس منقضی می‌شود.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {product}, {domain}, {expirydate}</code>',
            ],

            'order_status_changed' => [
                'FriendlyName' => 'تغییر وضعیت سرویس',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'در زمان تغییر وضعیت سرویس.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {product}, {domain}, {status}, {date}</code>',
            ],

            'ticket_created' => [
                'FriendlyName' => 'تیکت جدید',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'زمان ایجاد تیکت<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {urgency}, {ticket_id}, {title},{status}, {date}</code>',
            ],
            'ticket_created_admin' => [
                'FriendlyName' => 'پیامک ثبت تیکت جدید مدیر',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'زمان ایجاد تیکت<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {urgency}, {ticket_id}, {title},{status}, {date}</code>',
            ],

            'ticket_status_changed' => [
                'FriendlyName' => 'تغییر وضعیت تیکت',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'در زمان تغییر وضعیت تیکت.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {urgency}, {ticket_id}, {title},{status}, {date}</code>',
            ],

            'ticket_reply' => [
                'FriendlyName' => 'ثبت پاسخ تیکت',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'در زمان ثبت پاسخ جدید به تیکت.<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {urgency}, {ticket_id}, {title},{status}, {date}</code>',
            ],

            'ticket_reply_admin' => [
                'FriendlyName' => 'پیامک ثبت پاسخ تیکت جدید مدیر',
                'Type' => 'textarea',
                'Rows' => '2',
                'Description' => 'زمان پاسخ تیکت<br>
            <b>متغیرها:</b> <code>{firstname}, {lastname}, {urgency}, {ticket_id}, {title},{status}, {date}</code>',
            ],
        ],

    ];
}


function amoot_sms_activate()
{
    return ['status' => 'success', 'description' => 'ماژول فعال شد.'];
}

function amoot_sms_deactivate()
{
    return ['status' => 'success', 'description' => 'ماژول غیرفعال شد.'];
}

function amoot_sms_output($vars)
{
    echo '<p>ماژول ارسال پیامک فعال است.</p>';
}


