<?php

function loggerAmoot($to, $message, $additionalInfo = null)
{
    // اگر اطلاعات اضافی وجود دارد، به پیام اضافه می‌شود
    if ($additionalInfo) {
        $additionalInfo .= " | " . json_encode($additionalInfo);
    }

    // $log = "Logger => [" . date('Y-m-d H:i:s') . "] To: $to | Message: $message | $additionalInfo \n";
    // file_put_contents(__DIR__ . '/amoot_sms_log.txt', $log, FILE_APPEND);
}

function filterPhoneNumber($phone)
{
    // حذف همه کاراکترها به جز اعداد و +
    return preg_replace('/[^\d+]/', '', $phone);
}

function amoot_sms_send($to, $message, $token, $senderLine = null)
{
    $logPrefix = "SMS";

    // تشخیص پیامک خدماتی
    if (preg_match('/pcode:(\d+)/', $message, $matches)) {
        $patternId = (int) $matches[1];

        // استخراج فیلدهای key:value
        preg_match_all('/(\w+):(\{[^}]+\}|\S+)/', $message, $parts, PREG_SET_ORDER);

        $params = [];
        foreach ($parts as $part) {
            if ($part[1] !== 'pcode') {
                $params[] = trim($part[2], '{}'); // حذف {} از مقادیر
            }
        }

        $paramsStr = implode(',', $params);

        // انتخاب وب‌سرویس بر اساس وجود خط اختصاصی
        if ($senderLine) {
            $url = "https://portal.amootsms.com/rest/SendWithPatternOWN?Token={$token}&SendDateTime=0&PatternCodeID={$patternId}&PatternValues=" . urlencode($paramsStr) . "&LineNumber=" . urlencode($senderLine) . "&Mobile=" . urlencode($to);
            $logPrefix .= " (Pattern + OWN)";
        } else {
            $url = "https://portal.amootsms.com/rest/SendWithPattern?Token={$token}&PatternCodeID={$patternId}&PatternValues=" . urlencode($paramsStr) . "&Mobile=" . urlencode($to);
            $logPrefix .= " (Pattern)";
        }
    } else {
        // پیامک ساده
        $url = "https://portal.amootsms.com/rest/SendSimple?Token={$token}&To=" . urlencode($to) . "&Message=" . urlencode($message);
        $logPrefix .= " (Simple)";
    }

    loggerAmoot($logPrefix, "Sending to $to using URL: $url");

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
    ]);

    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        loggerAmoot($logPrefix . ' ERROR', $err);
        return false;
    }

    loggerAmoot($logPrefix . ' RESPONSE', $response);
    return $response;
}



function amoot_sms_parse_template($template, $vars)
{
    foreach ($vars as $key => $val) {
        $template = str_replace('{' . $key . '}', $val, $template);
    }
    return $template;
}
